unit ModbusAbakusTest;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, AdPacket, OoMisc, AdStatLt, AdPort, StdCtrls, ComCtrls,
  AbMTrend, AbVBar, AbTank, _GClass, AbRMeter, Spin;

type
  TForm1 = class(TForm)
    AVRcoModbusComPort: TApdComPort;
    Memo1: TMemo;
    ReadModbusTagsTimer: TTimer;
    ModbusDataReceived: TApdDataPacket;
    Voltage1Ab120Meter: TAb120Meter;
    Voltage1AbTank: TAbTank;
    Voltage1AbVBar: TAbVBar;
    Voltage1AbMiniTrend: TAbMiniTrend;
    RunButton: TButton;
    ComPortSpinEdit: TSpinEdit;
    Label4: TLabel;
    procedure ReadModbusTagsTimerTimer(Sender: TObject);
    procedure ModbusDataReceivedStringPacket(Sender: TObject;
      Data: String);
    procedure RunButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ComPortSpinEditChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.ReadModbusTagsTimerTimer(Sender: TObject);
begin
   AVRcoModbusComPort.Output := ':010400080002F1' + CHR(13) + CHR(10);
end;

procedure TForm1.ModbusDataReceivedStringPacket(Sender: TObject;
  Data: String);
var
   f: single;
   l: longword;
   p: pointer;
   ps: psingle;
   s: string;
begin
   // Since this is a quick example, we will not calculate LRC.
   // If you want that, you can find example how to do it in AVRco source.
   s := '$' + Copy(Data, 5, 4) + Copy(Data, 1, 4);
   l := StrToInt(s);

   // let's convert longword to float
   p  := @l;
   ps := PSingle(P);
   f  := ps^;

   Voltage1Ab120Meter.Value := f;
   Voltage1AbVBar.Digit := Round(f*100);
   if Voltage1Ab120Meter.Tag = 0 then
   begin
      Voltage1Ab120Meter.Tag := 1;
      Voltage1Ab120Meter.MinMax.Min := f;
      Voltage1Ab120Meter.MinMax.Max := f;
      Voltage1AbVBar.MinMax.Min := f;
      Voltage1AbVBar.MinMax.Max := f;
   end;
   Voltage1AbTank.Digit := Round(f*100);
   Voltage1AbMiniTrend.DigitCh2 := Round(f*100);
end;

procedure TForm1.RunButtonClick(Sender: TObject);
begin
   Voltage1AbMiniTrend.Flow := true;
   ReadModbusTagsTimer.Enabled := false;
   AVRcoModbusComPort.Open := false;
   AVRcoModbusComPort.ComNumber := ComPortSpinEdit.Value;
   AVRcoModbusComPort.Open := true;
   ReadModbusTagsTimer.Enabled := true;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   ReadModbusTagsTimer.Enabled := false;
end;

procedure TForm1.ComPortSpinEditChange(Sender: TObject);
begin
   ReadModbusTagsTimer.Enabled := false;
   Voltage1AbMiniTrend.Flow := false;
end;

end.
